from matplotlib.lines import Line2D
import xlrd
import pandas as pd
import os
import numpy as np
from matplotlib import pyplot as plt
from matplotlib.markers import MarkerStyle
from matplotlib.pyplot import MultipleLocator

def get_data(file, type):
    data = pd.read_csv(file)
    target_list = data[type]
    return target_list.values

def get_mean_and_std(method, file, data, interp, type, n):
    m = []
    s = []
    val = []
    seed = ['0', '1', '2', '3', '4']
    if method == 'dmfal':
        for i in seed:
            f = "exp_epoch_line/" + method + "/" + file + "/" + data + "_Seed[" + i + "]_" + interp + ".csv"
            val.append(get_data(f, 'rmse'))
    else:
        for i in seed:
            f = "exp_epoch_line/" + method + "/" + file + "/" + data + "_Seed[" + i + "]_" + interp + ".csv"
            val.append(get_data(f, type))

    for i in range(n):
        temp = []
        for j in range(len(seed)):
            temp.append(val[j][i])
        temp = np.array(temp)
        m.append(temp.mean())
        s.append(temp.std())

    return np.array(m), np.array(s)

def makedir(path):
    isExists = os.path.exists(path)
    if not isExists:
        os.makedirs(path)
        return True
    else:
        return False

if __name__ == '__main__':
    ratio = 1

    # 32 rmse
    # method = ['ResGP', 'LarGP', 'NAR','DC_cigp', 'dmfal', 'SGAR', 'GAR']
    # file_name = 'poisson_v4_02_l2h_32_int'
    # data_name = 'poisson_v4_02'
    # interp = 'Interp[True]'
    # max_num = 32

    # 64 r2
    # method = ['NAR','DC_cigp', 'dmfal', 'SGAR', 'GAR']
    # file_name = 'poisson_v4_02_l2h_32'
    # data_name = 'poisson_v4_02'
    # interp = 'Interp[False]'
    # max_num = 32

    # 128 rmse
    method = ['dmfal', 'SGAR', 'GAR']
    file_name = 'poisson_v4_02'
    data_name = 'poisson_v4_02'
    interp = 'Interp[False]'
    # max_num = 733 # top
    max_num = 1000 # sofc

    color_dic = {'GAR':'#DC143C', 'dmfal':'#2ca02c', 'SGAR':'#1f77b4'}
    marker_dic = {'GAR':"o", 'dmfal':"s", 'SGAR':"^"}
    lw_dic = {'GAR':2.5, 'SGAR':2.5, 'dmfal':2.5}
    label_dic = {'GAR':'GAR', 'dmfal':'MF-BNN', 'SGAR':'CIGAR'}
    marker = ["o", "s", "^", "v", "*", "d", "h", "p", "x", "+"]
    color = ['#DC143C', '#1f77b4', '#2ca02c', '#ff7f0e', '#8c564b', '#708090', '#7f7f7f', '#000000', '#17becf']  # bcbd22
    orders = [i for i in range(max_num)]
    vals = []
    vars = []
    for i in range(len(method)):
        if True:
            m, s = get_mean_and_std(method[i], file_name, data_name , interp, 'rmse', max_num)
            vals.append(m)
            vars.append(s)
            plt.plot(orders[::15], vals[i][::15], linewidth=lw_dic[method[i]], color=color_dic[method[i]], label= label_dic[method[i]])
            plt.fill_between(orders, vals[i] - vars[i] * 1, vals[i] + vars[i] * 1, alpha=0.4, color=color_dic[method[i]])
    
            # m, s = get_mean_and_std(method[i], file_name, data_name , interp, 'rmse', max_num)
            # vals.append(m)
            # vars.append(s)
            # plt.plot(orders, vals[i], linewidth=lw_dic[method[i]], color=color_dic[method[i]], label= label_dic[method[i]])
            # plt.fill_between(orders, vals[i] - vars[i] * 1, vals[i] + vars[i] * 1, alpha=0.4, color=color_dic[method[i]])
        
    plt.xlabel("#epoch", fontsize=17)
    plt.ylabel("RMSE", fontsize = 17)
    ax = plt.gca()
    plt.xticks(orders[::100])
    plt.tick_params(axis='x', labelsize=13)
    plt.tick_params(axis='y', labelsize=17)
    # plt.legend(loc='upper right', fontsize=12)
    # plt.title(file_name,fontsize = 12)
    plt.grid()
    # plt.show()

    # makedir(r"fig")
    fig_file = r"fig_" + file_name + ".pdf"
    plt.savefig(fig_file, bbox_inches = 'tight')